

  ' Started....18-12-24
' Microcontroller used:  Microchip Technology PIC16F1455
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com     

'--------Program Desciption--------
' Software to enable the control the speed and direction of two trains
 

#CONFIG
        __config _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
        __config _CONFIG2, _FCMEN_OFF & _PLLEN_DISABLED & _LVP_OFF
#ENDCONFIG
                                                                
  
 'include "modedefs.bas" 
  
 OSCCON = %00110110   '4mhz int osc
 OSCTUNE = %00000000 
 define OSC 4 
 Define SER2_BITS 8 
OPTION_REG.7 = 1 ' PORT A&B Pull-Ups disabled 
INTCON.7 = 0 ' disable external interrupts
INTCON.6 = 0 'disable pher interrupts    

ADCON1 = %00010000' Vref connected to +5V left justified 8 bit

FVRCON.7 = 0 'Vref module off
define  ADC_BITS 8       ' measure *bits
'define  ADC_CLOCK    3     ' Set clock source (3=rc)
'define CHAR_PACING 1000
Define  ADC_SAMPLEUS 50    ' Set sampling time in uS    
DACCON0.7 = 0  'DAC off



T1CON.0 = 0 'timer 1 off
CM1CON0    = %00000000 ' Comparator1 Module is OFF
CM2CON0    = %00000000 ' Comparator2 Module is OFF
UCON.3 = 0  'USB off 
UCON.1 = 1  'USB module in power conserve
SSPCON1.5 = 0 'disable serial ports  
WPUA       = %00000000 'weak pull ups disabled
PWM2CON.7 = 0 'PWM 2 is off
 PWM2CON.6 = 0  'PWM 2 output disable

 PWM1CON.7 = 0 'PWM 1 is off
 PWM1CON.6 = 0  'PWM 1 output disable 




TRISA      = %00001111 ' RA0,RA1,No RA2,RA3 MCRL inputs rest outputs
ANSELA     = %00000000 'all digital 
TRISC      = %00001111 ' RC0,RC1'RC2,RC3 inputs rest outputs                                                                                          
ANSELC     = %00000011 ' RC0 RC1 analogue rest digital 

 
  a var byte 'train 1 check 
  b var byte 'train 1 speed
  c var byte 'Train 1 forward reverse
  d var byte 'Train 1 speed 2
  e var byte 'no of times data sent
  
  f var byte' train 1 check       
  g var byte' train 2 check 
  h var byte' Train 2 speed
  i var byte' Train 2 forward reverse
  j var byte' Train 2 speed 2
  k var byte' Train 2 check  2
   '----------Initialization---------
  
   a = 30
   b = 0
   c = 5 ' or 10 reverse
  d = 0 
   e = 0  
   f = 38
   
   g = 23
   h = 0
   i = 7 'or 12 reverse
   j = 0
   k = 45  
 
 
 Main:
 
   If PORTC.2 = 1 then c = 5 'forward
   if PORTC.2 = 0 then c = 10
   if PORTC.3 = 1 then i = 7 'forward
   if PORTC.3 = 0 then i = 12
 
 serout2 PORTC.4,1091,1,["B","A",(50)]  'send serial data at 900baud with 1ms char spacing
 serout2 PORTC.4,1091,1,["B","C",(50)]  'send serial data at 900baud with 1ms char spacing
 
  pauseus 10
 
  ADCON0 = %00010011    ' A/D Module on analogue 4(RC0) selected 
  ADCIN 4, b  '0 to 255 ' measure pulse time and store in b
  
  pauseus 10
  ADCON0 = %00010111   'A/D Module on analogue 5 (RC1)
  adcin 5, h  '0 to 255 store in h
   pauseus 25
  
   If h > (j + 1) or H < (j - 1) then goto Send2
   if b > (d + 1) or B < (d - 1) then goto Send1
   j = h
   d = b
   goto main 
   
 
   Send1: 
   for e = 1 to 10  ' 
 
     
   SEROUT2 PORTC.4,1091,1,["B","A",(f),(b),(c),(a)]  'send serial data with ASCII char A as qualifier and data in variables a,b and c at 900baud 1ms char spacing
   pauseus 5
   
 
   next e
   d = b
   goto Main 
  
   Send2: 
   for e = 1 to 10  ' 
  
    SEROUT2 PORTC.4,1091,1,["B","C",(k),(h),(i),(g)]  'send serial data with ASCII char A as qualifier and data in variables a,b and c at 900baud 1ms char spacing
   pauseus 5
  
  
   next e
   j = h
   goto Main
 


